/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0, 0.0,0.0)

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

//testing python script that generates shadertoy code form a simple OBJ file

//python output phase 1
const vec3
v1 = vec3(0.0, -0.525731, 0.850651),
v2 = vec3(0.850651, 0.0, 0.525731),
v3 = vec3(0.850651, 0.0, -0.525731),
v4 = vec3(-0.850651, 0.0, -0.525731),
v5 = vec3(-0.850651, 0.0, 0.525731),
v6 = vec3(-0.525731, 0.850651, 0.0),
v7 = vec3(0.525731, 0.850651, 0.0),
v8 = vec3(0.525731, -0.850651, 0.0),
v9 = vec3(-0.525731, -0.850651, 0.0),
v10 = vec3(0.0, -0.525731, -0.850651),
v11 = vec3(0.0, 0.525731, -0.850651),
v12 = vec3(0.0, 0.525731, 0.850651);
const mat3
f0 = mat3(v2, v3, v7),
f1 = mat3(v2, v8, v3),
f2 = mat3(v4, v5, v6),
f3 = mat3(v5, v4, v9),
f4 = mat3(v7, v6, v12),
f5 = mat3(v6, v7, v11),
f6 = mat3(v10, v11, v3),
f7 = mat3(v11, v10, v4),
f8 = mat3(v8, v9, v10),
f9 = mat3(v9, v8, v1),
f10 = mat3(v12, v1, v2),
f11 = mat3(v1, v12, v5),
f12 = mat3(v7, v3, v11),
f13 = mat3(v2, v7, v12),
f14 = mat3(v4, v6, v11),
f15 = mat3(v6, v5, v12),
f16 = mat3(v3, v8, v10),
f17 = mat3(v8, v2, v1),
f18 = mat3(v4, v10, v9),
f19 = mat3(v5, v9, v1);

vec3 rotateXY(vec3 p, vec2 c, vec2 s) {
    p = vec3(p.x, c.x*p.y + s.x*p.z, -s.x*p.y + c.x*p.z);
    return vec3(c.y*p.x + s.y*p.z, p.y, -s.y*p.x + c.y*p.z);
}

vec3 triBarycentric(const in vec4 a, const in vec4 b) {
    vec4 p =(vec4(a.z,b.wxy) - vec4(b.xyz,a.w)) * a.yxyx,
         q = vec4(a.wz, b.yx) * b,
         r = vec4(q.zx - q.wy, a.zw * b.wz);
    float det = r.x + r.y + r.z - r.w;
    if (det == 0.) return vec3(0.);
    vec2 t = (r.xy + p.yw + p.zx)/det;
    float w = t.x + t.y;
    if(t.x<0.||t.y<0.||w>1.) return vec3(0.);
    return vec3(1. - w, t);
}
#define insideTriangle(p,a,b,c) triBarycentric(vec4(p,a),vec4(b,c))

vec3 drawFace(in mat3 face, vec2 cs, vec2 sn, vec2 uv) {
    vec3 a = rotateXY(face[0], cs, sn), b = rotateXY(face[1], cs, sn), c = rotateXY(face[2], cs, sn);
    vec3 n = normalize(cross(b-a, c-a));
    if (n.z < 0.) return vec3(0.);
    vec3 smp = insideTriangle(uv,a.xy,b.xy,c.xy);
    if (smp.x+smp.y+smp.z == 0.) return smp;
    return texture2D(iChannel0, smp.xy).rgb * (n.z*n.z+0.3);
}

void main( void ) {
    //zoom out a bit
    vec2 uv = (gl_FragCoord.xy / iResolution.xx) * 4. - vec2(2.,1.),
         ang = vec2(sin(iGlobalTime*0.1)*0.5, iGlobalTime*0.2),
         cs = cos(ang),
         sn = sin(ang);
    gl_FragColor = vec4(0.,0.,0.,0.);
    
    //python output phase 2
    gl_FragColor.rgb += drawFace(f0, cs, sn, uv);
    gl_FragColor.rgb += drawFace(f1, cs, sn, uv);
    gl_FragColor.rgb += drawFace(f2, cs, sn, uv);
    gl_FragColor.rgb += drawFace(f3, cs, sn, uv);
    gl_FragColor.rgb += drawFace(f4, cs, sn, uv);
    gl_FragColor.rgb += drawFace(f5, cs, sn, uv);
    gl_FragColor.rgb += drawFace(f6, cs, sn, uv);
    gl_FragColor.rgb += drawFace(f7, cs, sn, uv);
    gl_FragColor.rgb += drawFace(f8, cs, sn, uv);
    gl_FragColor.rgb += drawFace(f9, cs, sn, uv);
    gl_FragColor.rgb += drawFace(f10, cs, sn, uv);
    gl_FragColor.rgb += drawFace(f11, cs, sn, uv);
    gl_FragColor.rgb += drawFace(f12, cs, sn, uv);
    gl_FragColor.rgb += drawFace(f13, cs, sn, uv);
    gl_FragColor.rgb += drawFace(f14, cs, sn, uv);
    gl_FragColor.rgb += drawFace(f15, cs, sn, uv);
    gl_FragColor.rgb += drawFace(f16, cs, sn, uv);
    gl_FragColor.rgb += drawFace(f17, cs, sn, uv);
    gl_FragColor.rgb += drawFace(f18, cs, sn, uv);
    gl_FragColor.rgb += drawFace(f19, cs, sn, uv);
    
    gl_FragColor.a = 1000.0*length(gl_FragColor.rgb);

}